' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class UserDetails
  Inherits System.Web.UI.Page

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    plcNewUser.Visible = False
    plcReturningUser.Visible = False

    If Not Page.IsPostBack Then
      If Profile.ProfileCompleted Then
        txtFirstName.Text = Profile.FirstName
        txtLastName.Text = Profile.LastName
        txtStreet.Text = Profile.Address.Street
        txtZipCode.Text = Profile.Address.ZipCode
        txtCity.Text = Profile.Address.City
        txtCountry.Text = Profile.Address.Country
        plcReturningUser.Visible = True
      Else
        plcNewUser.Visible = True
      End If
    End If
  End Sub

  Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
    Page.Validate()
    If Page.IsValid Then
      Profile.FirstName = txtFirstName.Text
      Profile.LastName = txtLastName.Text
      Profile.Address.Street = txtStreet.Text
      Profile.Address.ZipCode = txtZipCode.Text
      Profile.Address.City = txtCity.Text
      Profile.Address.Country = txtCountry.Text
      Profile.ProfileCompleted = True
      If ShopManager.ShoppingCart.Count > 0 Then
        Response.Redirect("~/Shop/CheckOut.aspx")
      Else
        Response.Redirect("~/")
      End If
    End If
  End Sub
End Class
